#|_______________________________________________
 |
 | vismenu1.lsp
 | Contains code to define ViSta's main menus:
 | DATA, PLOTS, VIEWS, TRANSFORM, and MODEL menus
 | ANALYZE menu items are now defined by plugins.
 | Copyright (c) 1991-2002 by Forrest W. Young
 |_______________________________________________
 |#

#+X11(defun about-xlisp-stat ()
    (message-dialog (format nil "XLISP-PLUS version 2.1g~%~
Portions Copyright (c) 1988, by David Betz~%~
Modified by Thomas Almy and others.~%~%~
XLISP-STAT Version 2.1 Release ~d.~d  (Beta).~%~
Statistical additions to XLISP by Luke Tierney~%~
Copyright 1990 (c) by Luke Tierney"
xls-major-release xls-minor-release)))

#| fwy moved to maketime/defvar.lsp
(defproto expert-menu-item-proto () () menu-item-proto)

;fwy4.28 7/16/97 modified so that menu items can show help
(defmeth expert-menu-item-proto :do-action (&optional w)
  (when (and (not (send *vista* :show-help))
             (author)) (copyitem (send self :title) nil w))
  (when (send *vista* :show-help) 
        (send *workmap* :show-help self t (send self :title) nil ))
  (when (not (send *vista* :show-help))
        (when (send self :action) (funcall (send self :action)))))
|#
;; X11 doesn't have a file-menu? AJR
#+X11 (defvar *file-menu* (send menu-proto :new "File"))
#+X11 (send   *file-menu* :enabled nil)



(defproto vista-menu-item-proto '(ok-data=types) () expert-menu-item-proto)

(defmeth vista-menu-item-proto :ok-data-types (&optional (list nil set))
  (if set (setf (slot-value 'ok-data=types) list))
  (slot-value 'ok-data=types))

(defmeth vista-menu-item-proto :isnew 
  (title &key (enabled t) (action nil) (ok-data-types) (mark nil))
  (send self :ok-data-types ok-data-types)
  (call-next-method title :enabled enabled :action action :mark mark))


(defmeth menu-proto :set-vista-menu-item-states (dob)
  (cond
    (dob
     (send self :enabled t)
     (mapcar #'(lambda (item)
              (unless (equal (send item :title) "-")
                      (if 
                       (member (send dob :generalized-datatype) 
                               (send item :ok-data-types) :test #'equal)
                       (send item :enabled t)
                       (send item :enabled nil))))
          (send self :items)))
    (t
     (send self :enabled nil)))
  (send self :enabled))


#|_______________________________________________
 |
 |    *DATA-MENU*
 |_______________________________________________
 |#

(defvar *data-menu* (send menu-proto :new "Data"))
(send   *data-menu* :enabled nil)

(setf guide-data-menu-item
      (send expert-menu-item-proto :new "Guidance"
            :action #'(lambda () (guidance "data"))))

(setf load-data-menu-item
      (send expert-menu-item-proto :new "Load Data ..." :key #\D
            :action 'load-data))

(setf save-data-menu-item
      (send expert-menu-item-proto :new "Save Data As ..." :enabled nil
            :action 'save-data-as))

(defun create-convert-data () (send *current-data* :create-data))
(defun convert-data-object () (send *current-data* :create-data))

(setf about-data-menu-item
      (send expert-menu-item-proto :new "About These Data" :enabled nil
            :action 'about-these-data))

;following item added by fwy 090220
(setf data-header-menu-item
      (send expert-menu-item-proto :new "Data Header" :enabled nil
            :action 'data-header))

(setf create-dob-data-menu-item
      (send expert-menu-item-proto :new "Create Data Object" :enabled nil
            :action #'(lambda () (send *current-data* :create-data))))

(defun create-stats-object ()
  (send *current-data* :create-summary-data))

(setf create-summary-data-menu-item
      (send expert-menu-item-proto :new "Create Stats Object" :enabled t
            :action #'(lambda () (create-stats-object))))

(setf show-vars-menu-item
      (send expert-menu-item-proto :new "List Variables" :enabled nil
            :action 'list-variables))

(setf show-obs-menu-item
      (send expert-menu-item-proto :new "List Observations" :enabled nil
            :action 'list-observations))

(defun selector-enable-state ()
  (equal *current-data* *current-object*))

(setf focus-selection-data-menu-item
      (send expert-menu-item-proto :new "IN - Include Selection" 
            :enabled nil ;(equal *current-data* *current-object*)
            :action 'focus-on-selected-obs-vars))

(setf remove-selection-data-menu-item 
      (send expert-menu-item-proto :new "OUT - Exclude Selection" 
            :enabled nil ;(equal *current-data* *current-object*)
            :action 'remove-selected-obs-vars))

(setf cancel-selection-data-menu-item
      (send expert-menu-item-proto :new "DROP - Drop Selection " 
            :enabled nil ;(equal *current-data* *current-object*)
            :action 'cancel-obs-vars-selection))
      (send dash-item-proto :new)

(setf unselect-selection-data-menu-item
      (send expert-menu-item-proto :new "RESET - Reset Selection" 
            :enabled nil ;(equal *current-data* *current-object*)
            :action 'show-all-obs-vars))

;used by cloaner
(setf *selector-items*
      (list
       focus-selection-data-menu-item
       remove-selection-data-menu-item 
       cancel-selection-data-menu-item
       unselect-selection-data-menu-item))

      
(setf merge-vars-menu-item 
      (send expert-menu-item-proto :new "Merge Variables" :enabled nil
            :action 'merge-variables))

(setf merge-obs-menu-item
      (send expert-menu-item-proto :new "Merge Observations" :enabled nil
            :action 'merge-observations))

(setf merge-mats-menu-item
      (send expert-menu-item-proto :new "Merge Matrices" :enabled nil
            :action 'merge-matrices))

(setf visualize-data-menu-item
      (send expert-menu-item-proto :new "Visualize Data ..." :enabled nil
             :action #'(lambda () (visualize-data :dialog t))))

;(defun list-data () (data-listing))

(defun print-data () 
  (send (send $ :report) :print-text)
  )

(setf print-data-menu-item
      (send expert-menu-item-proto :new "Print Data" :enabled t :key #\R
            :action #'(lambda () (print-data))))

(setf report-data-menu-item
      (send expert-menu-item-proto :new "List Data" :enabled t :key #\R
            :action #'(lambda () (list-data))))

;following statement modified by fwy 090220
(setf *data-icon-cap-items*
      (list
       about-data-menu-item
       data-header-menu-item))

(setf freq-tables-data-menu-item
      (send expert-menu-item-proto :new "CrossTabulate Data" :enabled nil
            :action #'(lambda () (crosstabulate-data))))

(setf summarize-data-menu-item
      (send expert-menu-item-proto :new "Summarize Data ..." :enabled nil
            :key #\Y :action #'(lambda () (summarize-data :dialog t))))

(setf impute-missing-data-menu-item
      (send expert-menu-item-proto :new "Impute Missing Data ..." :enabled nil
            :action #'(lambda () (impute-missing-data :dialog t))))


(setf delete-icon-menu-item 
       (send expert-menu-item-proto :new "Delete Icon ..." :enabled nil
            :action #'(lambda () (delete-icon-menu-item :dialog t))))

;(defmeth delete-icon-menu-item :enabled (nilt) 
;   (send delete-icon-menu-item :enabled nilt))

(defun delete-data-object () 
	(when *current-data* (setcd *current-data*) (delete-object)))

(setf delete-data-menu-item 
      (send expert-menu-item-proto :new "Delete Data Object ..." :enabled t
            :action 'delete-data-object))

(defun view-datastep-code ()
  ;send *vista* :file-to-window 
  (if (send *current-data* :datafile)
      (file-to-window
       (send *current-data* :datafile) 
       (format nil "ViSta DataCode for Data Object ~a" (send *current-data* :full-name)) 
       *help-window* :add-help nil)
      (message-dialog "These Data do not have a DataFile.~%You must save them first.")))
      
(defun edit-datastep-code ()
  (set-working-directory *default-path*)
  (if (send *current-data* :datafile)
      (system (strcat "lspedit.exe " (send *current-data* :datafile)))
      (message-dialog "These Data do not have a DataFile.~%You must save them first.")))

#|fwy moved to defun0.lsp 09-22-02
(defun xlispstat-window (&key (viva nil))
  (defaultmainwindow)
  (send *show-xlispstat-window-item* :mark t)
  ;(show-xlispstat-window)
  (when viva (print-viva-listener-help))
  )
|#

(defun get-datacode (&optional edit)
  (edit-source t))

(defun edit-source (&optional edit)
  (let ((filename)
	(wd (get-working-directory))
        (datafile (send *current-data* :datafile)))
    (cond
      ((not *current-data*)
       (message-dialog "There are no data.")
       (top-level nil))
      (t
       (setf filename (strcat (pathname-name datafile) "." 
                              (pathname-type datafile)))
       (unless filename (message-dialog "Corrupt filename") (top-level nil)) 
       (unless (probe-file filename)
               (save-data filename))
       (set-working-directory 
          (strcat (pathname-device datafile) ":" (directory-namestring datafile))) 
       (cond
         ((> (file-length (open-file datafile)) 31000)
          (format t "; long file. notepad to the rescue.~%")
          (system (strcat "notepad.exe " filename)))
         (t
          (system (strcat *default-path* "lspedit.exe " filename))))))
      (set-working-directory wd)
      filename))


(defun variable-editor () (xlispstat-window :viva t))

(defun print-datacode (&optional edit)
  (print-source nil))

(defun print-source (&optional edit)
  (let ((filename)
	(wd (get-working-directory))
        (datafile (send *current-data* :datafile)))
    (cond
      ((and (not edit) (not *current-data*))
       (message-dialog "There is nothing to print.")
       (top-level nil))
      (t
       (setf filename (strcat (pathname-name datafile) "." 
                              (pathname-type datafile)))
       (unless filename (message-dialog "Corrupt filename") (top-level nil)) 	
       (set-working-directory 
          (strcat (pathname-device datafile) ":" (directory-namestring datafile))) 
       (system (strcat "notepad.exe /p " filename))))
      (set-working-directory wd)
      filename))


(setf browse-data-menu-item
      (send expert-menu-item-proto :new "Browse Data" :enabled t :key #\B
            :action #'(lambda () (browse-data))))

(setf edit-data-menu-item
      (send expert-menu-item-proto :new "Edit Data" :enabled t :key #\D
            :action #'(lambda () (edit-data))))

(setf edit-datastep-code-menu-item
      (send expert-menu-item-proto :new "Edit Source" :enabled t :key #\D
            :action #'(lambda () (edit-source))))


(setf print-datacode-menu-item
      (send expert-menu-item-proto :new "Print Source" :enabled t
            :action 'print-source))

(setf PRINT-DATASTEP-CODE-MENU-ITEM print-datacode-menu-item)

(defun edit-variables () (viva-window))

(setf edit-variables-menu-item
      (send expert-menu-item-proto :new "Edit Variables" :enabled t
            :action 'edit-variables))

;following modified by fwy 090220
(setf *data-icon-items*
      (list visualize-data-menu-item
            summarize-data-menu-item
            (send dash-item-proto :new)
            create-summary-data-menu-item
            create-dob-data-menu-item
            delete-data-menu-item
            (send dash-item-proto :new)
            edit-data-menu-item
            edit-datastep-code-menu-item
            (send dash-item-proto :new)
            print-data-menu-item
            print-datacode-menu-item))
            
(setf show-datasheet-menu-item edit-data-menu-item)

;following modified by fwy 090220
(send *data-menu* :append-items
      about-data-menu-item
      data-header-menu-item
      ;browse-data-menu-item
      (send dash-item-proto :new)
      visualize-data-menu-item
      summarize-data-menu-item
     ; freq-tables-data-menu-item
     ; (send dash-item-proto :new)
      report-data-menu-item
      (send dash-item-proto :new)
      create-summary-data-menu-item
      create-dob-data-menu-item
      delete-data-menu-item 
     ; (send dash-item-proto :new)
     ; focus-selection-data-menu-item 
     ; remove-selection-data-menu-item  
     ; cancel-selection-data-menu-item 
     ; unselect-selection-data-menu-item
      (send dash-item-proto :new)
      impute-missing-data-menu-item
      (send dash-item-proto :new)
      edit-data-menu-item
      edit-datastep-code-menu-item
      edit-variables-menu-item
      (send dash-item-proto :new)
      print-data-menu-item 
      print-datastep-code-menu-item
      (send dash-item-proto :new)
      merge-vars-menu-item
      merge-obs-menu-item
      merge-mats-menu-item
     ; (when (send *vista* :show-long-menus)
     ;       (send dash-item-proto :new))
      )

#|_______________________
 |
 | PLOTS MENU
 |_______________________
 |#

(defvar *plots-menu* (send menu-proto :new "Plots"))

(send *plots-menu* :enabled nil)

(send *plots-menu* :append-items
        
      (send vista-menu-item-proto 
            :new "HistoGram Plot"                                    ;NEW DEF
            :ok-data-types '("class" "univariate" "bivariate" 
                                     "multivariate" "general")
            :enabled t
            :action  #'(lambda () (histogram-plot)))
      (send vista-menu-item-proto 
            :new "Distribution Plot"                                    ;NEW DEF
            :ok-data-types '("class" "univariate" "bivariate" 
                                     "multivariate" "general")
            :enabled t
            :action  #'(lambda () (distribution-plot)))
      (send vista-menu-item-proto                                        ;NEW DEF
            :new "Cumulative Plot" :enabled t  
            :ok-data-types '("class" "univariate" "bivariate" 
                                     "multivariate" "general")
            :action  #'(lambda () (cumulative-plot)))
      (send vista-menu-item-proto 
            :new "Comparison Plot" :enabled t                            ;NEW DEF
            :ok-data-types '("bivariate" "multivariate" "general")
            :action  #'(lambda () (comparison-plot)))
      (send dash-item-proto :new)      
      (send vista-menu-item-proto 
            :new "Dot Plot"                                    ;NEW DEF
            :ok-data-types '("class" "univariate" "bivariate" 
                                     "multivariate" "general")
            :enabled t
            :action  #'(lambda () (dot-plot)))
      (send vista-menu-item-proto :new "Scatter Plot" :enabled t             ;NEW DEF
            :ok-data-types '("bivariate" "multivariate" "general")
            :action #'(lambda () (scatter-plot))) 
      (send vista-menu-item-proto :new "Scatter Matrix" :enabled t
            :ok-data-types '("multivariate" "general")
            :action #'(lambda () (scatter-matrix)))    
      (send vista-menu-item-proto :new "Spinning Plot" :enabled t         ;NEW DEF
            :ok-data-types '("multivariate" "general")
            :action #'(lambda () (spinning-plot)))
      (send vista-menu-item-proto :new "Orbiting Plot"
             :ok-data-types '("multivariate" "general")
            :action #'(lambda () (orbiting-plot)))                       ;NEW DEF
      (send dash-item-proto :new)
      (send vista-menu-item-proto :new "Line Plot" :enabled t             ;NEW DEF
            :ok-data-types '("univariate" "bivariate" "multivariate" "general"
                             "class" "freq" "freqclass" "crosstabs")
            :action #'(lambda () (line-plot))) 
      (send dash-item-proto :new)
      (send vista-menu-item-proto :new "Box Plot" :enabled t ;NEW DEF
            :ok-data-types '("class" "univariate" "bivariate" 
                                     "multivariate" "general")
            :action #'(lambda () (box-plot)))
      (send vista-menu-item-proto :new "Diamond Plot" :enabled t ;NEW DEF
            :ok-data-types '("class" "univariate" "bivariate" 
                                     "multivariate" "general")
            :action #'(lambda () (diamond-plot)))
      (send vista-menu-item-proto :new "CatBox Plot" :enabled t
            :ok-data-types '("class" "general")
            :action  #'(lambda () (catbox-plot)))
      (send vista-menu-item-proto :new "ParaCoord Plot" :enabled t
            :ok-data-types '("bivariate" "multivariate" "general")
            :action  #'(lambda () (paracoord-plot)))  
      (send dash-item-proto :new)
      (send vista-menu-item-proto :new "Bar Graph" :enabled t                ;REDEF
            :ok-data-types '("class" "category" "freq" "freqclass" "crosstabs" "general")
            :action  #'(lambda () (bar-graph)))
      (send vista-menu-item-proto :new "Mosaic Plot" :enabled t              ;REDEF
            :ok-data-types '("class" "category" "freq" "freqclass" "crosstabs" "general")
            :action  #'(lambda () (mosaic-plot)))
      (send dash-item-proto :new)    
      (send vista-menu-item-proto 
            :new "Labels List"                                    ;NEW DEF
            :ok-data-types '("class" "univariate" "bivariate" 
                                     "multivariate" "general"
                                     "freq" "freqclass" 
                                     "crosstabs" "category")
            :enabled t
            :action  #'(lambda () (labels-list)))
      (send vista-menu-item-proto 
            :new "Variables List"                                    ;NEW DEF
            :ok-data-types '("class" "univariate" "bivariate" 
                                     "multivariate" "general"
                                     "freq" "freqclass" 
                                     "crosstabs" "category")
            :enabled t
            :action  #'(lambda () (variables-list)))
      (send vista-menu-item-proto 
            :new "Categories List"                                    ;NEW DEF
            :ok-data-types '("class" "general" "category" 
                                     "freq" "freqclass" "crosstabs")
            :enabled t
            :action  #'(lambda () (categories-list)))
      )

(setf *graphics-menu* *plots-menu* )

#|_______________________
 |
 | VIEWS MENU
 |_______________________
 |#




(defvar *spreadplot-menu* (send menu-proto :new "Views"))

(send *spreadplot-menu* :append-items
      (send vista-menu-item-proto 
            :new "Missing View" 
            :enabled t
            :ok-data-types '("missing")
            :action #'(lambda () (missing-view)))
      (send dash-item-proto :new)
      (send  vista-menu-item-proto 
             :new "Numeric View"
             :enabled t
             :ok-data-types '("univariate" "bivariate" "multivariate" "general")
             :action #'(lambda () (Numeric-view)))
      (send vista-menu-item-proto 
            :new "Category View"
            :enabled t
            :ok-data-types '("class" "classification" "crosstabs" "category" "general")
            :action #'(lambda () (Category-view)))
      (send dash-item-proto :new)
      (send vista-menu-item-proto 
            :new "Classified View"
            :enabled t
            :ok-data-types '("class" "classification" "general")
            :action #'(lambda () (Classified-view)))
      (send vista-menu-item-proto 
            :new "Frequency View"
            :enabled t
            :ok-data-types '("freq" "freqclass" "crosstabs" )
            :action #'(lambda () (Frequency-view)))
      (send vista-menu-item-proto 
            :new "CrossTab View"
            :enabled t
            :ok-data-types '("freq" "freqclass" "crosstabs" )
            :action #'(lambda () (Crosstab-view)))
      (send dash-item-proto :new)
      (send vista-menu-item-proto 
            :new "Relational View":enabled nil
            :ok-data-types '("matrix")
            :action #'(lambda () (relational-view)))
  #|
      (send dash-item-proto :new)
      (send vista-menu-item-proto 
            :new "Bivariate View":enabled nil
           ; :ok-data-types '("class"  "classification" "general")
            :action #'(lambda () (bivariate-view)))
      (send vista-menu-item-proto 
            :new "Scatterplot View"
            :ok-data-types '("multivariate" "general")
            :action #'(lambda () (scatterplot-view)))
      (send vista-menu-item-proto 
            :new "Mosaic View"
            :ok-data-types '("class" "classification" "freqclass" 
                                     "category" "crosstabs" "general")
            :action #'(lambda () (mosaic-view)))
      
      (send dash-item-proto :new)
      (send vista-menu-item-proto 
            :new "hD-View"
            :ok-data-types '("multivariate" "general")
            :action #'(lambda () (hD-View)))
    ;  (send dash-item-proto :new)
    ;  (send vista-menu-item-proto 
    ;        :new "Make A New View"
    ;        :action #'(lambda () (make-a-new-view)))
 |#
      )

(setf *views-menu* *spreadplot-menu*)
(send *spreadplot-menu* :enabled nil)


(defmeth *plots-menu* :enabled (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the plots and splots menus are enabled."
  (when set 
        (call-next-method logical)
        (send *views-menu* :enabled logical))
  (slot-value 'enabled)) 


#|_______________________________________________
 |
 |    *TRANS-MENU*
 |_______________________________________________
 |#



(defvar *trans-menu* (send menu-proto :new "Transform"))
(send   *trans-menu* :enabled nil)

(setf trnsps-trans-menu-item
      (send expert-menu-item-proto :new "Transpose Data"
            :enabled t
            :action 'transpose-data))

(setf norm-trans-menu-item
      (send expert-menu-item-proto :new "Standardize Data ... " 
            :enabled t
            :action #'(lambda () (standardize-data :dialog t))))

(setf orth-trans-menu-item
      (send expert-menu-item-proto :new "Orthogonalize Data" :enabled t
            :action 'orthogonalize-data))

(setf corr-trans-menu-item
      (send expert-menu-item-proto :new "Correlations" :enabled t
            :action 'correlations))

(setf covar-trans-menu-item
      (send expert-menu-item-proto :new "Covariances" :enabled t
            :action 'covariances))

(setf dist-trans-menu-item
      (send expert-menu-item-proto :new "Distances" :enabled t
            :action 'distances))

(setf sort-trans-menu-item
      (send expert-menu-item-proto :new "Sort-Permute ... " :enabled t
            :action #'(lambda () (sort-permute :dialog t))))

(setf rank-trans-menu-item
      (send expert-menu-item-proto :new "Ranks" :enabled t
            :action #'(lambda () (ranks :dialog t))))

(setf nscores-trans-menu-item
      (send expert-menu-item-proto :new "Normal Scores" :enabled t
            :action 'normal-scores))

(setf absval-trans-menu-item
      (send expert-menu-item-proto :new "Absolute Value" :enabled t
            :action 'absolute-value))

(setf exponent-trans-menu-item
      (send expert-menu-item-proto :new "Exponential ..." :enabled t
            :action #'(lambda () (exponential :dialog t))))

(setf logarithm-trans-menu-item
      (send expert-menu-item-proto :new "Logarithm ..." :enabled t
            :action #'(lambda () (logarithm :dialog t))))

(setf round-trans-menu-item
      (send expert-menu-item-proto :new "Rounding ... " :enabled t
            :action #'(lambda () (rounding :dialog t))))

(setf trig-trans-menu-item
      (send expert-menu-item-proto :new "Trigonometric ... " :enabled t
            :action #'(lambda () (trigonometric :dialog t))))

(setf recip-trans-menu-item
      (send expert-menu-item-proto :new "Reciprocal" :enabled t
            :action 'reciprocal))

(setf boxcox-trans-menu-item
      (send expert-menu-item-proto :new "Box-Cox Power"
            :action #'(lambda ()
                        (boxcox-transf :dialog t))
            :enabled t))

(setf Folded-Power-trans-menu-item
      (send expert-menu-item-proto :new "Folded Power"           
            :action #'(lambda ()
                        (Folded-Power-transf :dialog t)
                        :enabled t)))

(setf dummycode-trans-menu-item
      (send expert-menu-item-proto :new "Dummy coding"
           :action #'(lambda ()
                        (dummy-code :dialog t)
            :enabled t)))

(setf split-trans-menu-item
      (send expert-menu-item-proto :new "Split By Categories"
           :action #'(lambda ()
                        (split-by-categories :dialog t)
            :enabled t)))

(setf join-trans-menu-item
      (send expert-menu-item-proto :new "Join Category Variables"
           :action #'(lambda ()
                        (join-category-variables :dialog t)
            :enabled t)))

(defun interactive-variable-algebra () (send *vista* :user-defined-transformation))

(setf edit-variables-menu-item
      (send expert-menu-item-proto :new "Program Editor" :enabled t
            :action 'interactive-variable-algebra))

(send *trans-menu* :append-items
      sort-trans-menu-item         ;0
      rank-trans-menu-item         ;1
      (send dash-item-proto :new)  ;2
      nscores-trans-menu-item      ;3
      absval-trans-menu-item       ;4  
      round-trans-menu-item        ;5
      recip-trans-menu-item        ;6 
      (send dash-item-proto :new)  ;7
      exponent-trans-menu-item     ;8
      logarithm-trans-menu-item    ;9
      trig-trans-menu-item         ;10
      (send dash-item-proto :new)  ;11
      corr-trans-menu-item         ;12
      covar-trans-menu-item        ;13
      dist-trans-menu-item         ;14
      (send dash-item-proto :new)  ;15
      trnsps-trans-menu-item       ;16
      norm-trans-menu-item         ;17
      orth-trans-menu-item         ;18
      (send dash-item-proto :new)  ;19
      Folded-Power-trans-menu-item ;20
      boxcox-trans-menu-item       ;21
      (send dash-item-proto :new)  ;22
      dummycode-trans-menu-item    ;23
      split-trans-menu-item        ;24
      join-trans-menu-item         ;25
      (send dash-item-proto :new)  ;26
      edit-variables-menu-item     ;27
      )




;fixes problem if first data is a missing values data

(mapcar #'(lambda (item) (send item :enabled t))
        (select (send *trans-menu* :items) 
                (iseq (length (send *trans-menu* :items)))))


#|_______________________________________________
 |
 |    *MODEL-MENU*
 |_______________________________________________
 |#

(defvar *model-menu* (send menu-proto :new "Model"))
(send   *model-menu* :enabled nil)


(setf guide-model-menu-item
      (send expert-menu-item-proto :new "Guidance" :enabled nil
            :action #'(lambda () (guidance "model"))))

(setf about-model-menu-item
      (send expert-menu-item-proto :new "About The Analysis" :enabled t
            :action 'about-the-analysis))

(setf load-model-menu-item
      (send expert-menu-item-proto :new "Load Model ..." :key #\M
            :action 'load-model))

(setf save-model-menu-item
      (send expert-menu-item-proto :new "Save Model As ..." :enabled nil
            :action 'save-model))


(setf save-model-model-menu-item
      (send expert-menu-item-proto :new "Save Model As ..." :enabled t
            :action 'save-model))

(setf delete-model-menu-item
      (send expert-menu-item-proto :new "Delete Model"  :enabled nil
            :action 'delete-model))

(setf visualize-model-menu-item
      (send expert-menu-item-proto :new "Visualize Model" :enabled nil
            :action #'(lambda () (visualize-model :dialog t))))

(setf report-model-menu-item
      (send expert-menu-item-proto :new "Report Model ... " :enabled nil
            :action #'(lambda () (report-model :dialog t))
            ))

(defun print-data-analysis () (print-all-reports))

(setf print-all-reports-menu-item
      (send expert-menu-item-proto :new "Print Data Analysis ..." :enabled t
            :action #'(lambda () (print-all-reports))
            ))

(setf interpret-model-menu-item
      (send expert-menu-item-proto :new "Interpret Model" :enabled nil
            :key #\I :action #'(lambda () (interpret-model))))

(setf create-dataobjects-model-menu-item
      (send expert-menu-item-proto :new "Create Data ..." :enabled nil
            :action #'(lambda () (send current-model :create-data :dialog t))))

(send *model-menu* :append-items  
   ;  guide-model-menu-item
      about-model-menu-item
     (send dash-item-proto :new)
      visualize-model-menu-item
      report-model-menu-item
      interpret-model-menu-item
      (send dash-item-proto :new)
      save-model-model-menu-item
      delete-model-menu-item
      create-dataobjects-model-menu-item
      (send dash-item-proto :new)
      print-all-reports-menu-item
    ;  (when (send *vista* :show-long-menus)
    ;        (send dash-item-proto :new))
      )


#|_______________________________________________
 |
 |    *ANALYZE-MENU*
 |
 | First three analyze menu items are defined
 | in maketime/defvar.lsp file.  
 | All additional are defined by plugins.
 |_______________________________________________
 |#


        
(provide "vismenu1")